<?php 
    $city = urlencode($_GET["city"]);
    $url="https://wttr.in/$city?lang=cs&format=j1";

    $cUrl = curl_init($url);
    //TODO: nastavit parametry cUrl
    curl_setopt($cUrl, CURLOPT_RETURNTRANSFER, true);

    $response=curl_exec($cUrl);

    curl_close($cUrl);

    //převeod na asociativní pole
    //$data dostanu z JSON formátu API
    $data = json_decode($response, true);
    $aktualniPodminky = $data["current_condition"][0];
    $teplota = $aktualniPodminky["temp_C"];
    $popis = $aktualniPodminky["lang_cs"]["0"]["value"];

    $lat = $data["nearest_area"][0]{"latitude"};
    $log = $data["nearest_area"][0]{"longitude"};
    $poloha = "$lat,$log";

    $rychlostVetru = $data["current_condition"][0]{"windspeedKmph"};

    $minTeplota = $data["weather"][0]{"mintempC"};
    $maxTeplota = $data["weather"][0]{"maxtempC"};

    $vlhkost = $data["current_condition"][0]{"humidity"};

    $pocasi = "{$_GET["city"]}: $popis $teplota °C";
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <title>Počasí</title>
</head>
<body>
    <div class="container">
        <h1>Počasí</h1>

        <form style="max-width:420px margin-bottom: 30px">
            <div class="mb-3">
                <label class="form-label">Zadejte město: </label>
                <input type="text" name="city" value="<?=$_GET["city"];?>" class="form-control">
            </div>
            <button class="btn btn-primary" type="submit">Zobrazit Počasí</button>
        </form>

        <div class="">
            <?php 
                echo "<p>$pocasi</p>";
                echo "<p>$poloha - <a href='https://www.google.com/maps/@$poloha,14z' target='_blank'>mapa</a></p>";
                echo "<p>Rychlst větru: $rychlostVetru km/h</p>";
                echo "<p>Minimální teplota je: $minTeplota °C</p>";
                echo "<p>Maximální teplota je: $maxTeplota °C</p>";
                echo "<p>Vlhkost: $vlhkost%</p>";
            ?>
        </div>
    </div>
</body>
</html>