<?php 
    $server = "websql.in.spsostrov.cz";
    $data = parse_ini_file("../../spso.mysql.ini");
    $username = $data["username"];
    $password = $data["password"];
    $database = $data["database"];

    $pdo = new PDO("mysql:host=$server;dbname=$database;charset=utf8mb4", $username, $password);
    $dotaz = "SELECT * FROM staty_eu";
    $result = $pdo->query($dotaz)->fetchAll();
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <title>Evropa</title>
</head>
<body>
<div class="container">
        <div class="row">
            <div class="col-md-9">
                <h1>Evropa</h1>
                <table class="table">
                    <th>Stát</th>
                    <th>Hlavni Město</th>
                    <th>Počet obyvatel</th>
                    <th>Rozloha</th>

                    <tbody>
                        <?php
                            foreach ($result as $row) {
                                echo "<tr>";
                                    echo "<td>" . htmlspecialchars($row['stat']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['hlavni_mesto']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['pocet_obyvatel']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['rozloha']) . "</td>";
                                echo "</tr>";
                            }
                        ?>
                    </tbody>
                </table>
            </div>

            <div class="col-md-3">
                <a href="?filtr=rozloha" class="btn btn-sm btn-primary m-2 d-block">Podle rozlohy</a>
                <a href="?filtr=obyvatelstvo" class="btn btn-sm btn-primary m-2 d-block">Podle počtu obyvatel</a>
                <a href="?filtr=abeceda" class="btn btn-sm btn-primary m-2 d-block">Podle abecedy</a>
            </div>
        </div>
    </div>
</body>
</html>