<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <?php
        session_start();
        $server = "websql.in.spsostrov.cz";
        $data = parse_ini_file("../spso.mysql.ini");
        $username = $data["username"];
        $password = $data["password"];
        $database = $data["database"];
        $pdo = new PDO("mysql:host=$server;dbname=$database;charset=utf8mb4", $username, $password, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        function detaiLGen($pdo, $id){
            $stmt = $pdo->prepare("SELECT * FROM planety WHERE id = ?");
            $stmt->execute([$id]);
            $radky = $stmt->fetchAll();
            return $radky[0];
        }
        if (isset($_GET["id"]) && is_numeric($_GET["id"]) && $_GET["id"] > 0 && $_GET["id"] < 9) {
            $planet = detaiLGen($pdo, htmlspecialchars($_GET["id"]));
        } else {
            header("Location: 05-planety-listing.php");
            die();
        }
        function getAllImagesInFolder($folderPath) {
            $images = [];
            $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
            
            if (is_dir($folderPath)) {
                $files = scandir($folderPath);
                foreach ($files as $file) {
                    $filePath = $folderPath . DIRECTORY_SEPARATOR . $file;
                    $fileExtension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                    if (is_file($filePath) && in_array($fileExtension, $allowedExtensions)) {
                        $images[] = $filePath;
                    }
                }
            }
            return $images;
        }
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            $id = $_POST['id'];
            $nazev = $_POST['nazev'];
            $polomer = $_POST['polomer'];
            $vzdalenost = $_POST['vzdalenost'];
            $url_obrazek = $_POST['url_obrazek'];
            $popis_kratky = $_POST['popiskratky'];
            $wikipedia = $_POST['wikipedia'];
            $clanek = $_POST['clanek'];

            $stmt = $pdo->prepare("UPDATE planety SET nazev = ?, polomer = ?, vzdalenost = ?, url_obrazek = ?, popis_kratky = ?, wikipedia = ?, clanek = ? WHERE id = ?");
            $stmt->execute([$nazev, $polomer, $vzdalenost, $url_obrazek, $popis_kratky, $wikipedia, $clanek, $id]);


            if (isset($_POST['delete_images'])) {
                foreach ($_POST['delete_images'] as $imageName) {
                    $imagePath = "planeta/" . $id . "/" . $imageName;
                    if (file_exists($imagePath)) {
                        unlink($imagePath);
                    }
                }
            }


            
            if (isset($_FILES['obrazky'])) {
                $uploadDir = "planeta/" . $id . "/";
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0755, true);
                }
                $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
                $maxBytes = 10 * 1024 * 1024; 

                foreach ($_FILES['obrazky']['tmp_name'] as $key => $tmpName) {
                    if (!isset($_FILES['obrazky']['error'][$key]) || $_FILES['obrazky']['error'][$key] !== UPLOAD_ERR_OK) {
                        continue;
                    }

                    if (!is_uploaded_file($tmpName)) {
                        continue;
                    }

                    if ($_FILES['obrazky']['size'][$key] > $maxBytes) {
                        continue;
                    }

                    $originalName = basename($_FILES['obrazky']['name'][$key]);
                    $ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
                    if (!in_array($ext, $allowedExtensions, true)) {
                        continue;
                    }


                    if (false === @getimagesize($tmpName)) {
                        continue;
                    }


                    $base = pathinfo($originalName, PATHINFO_FILENAME);
                    $safeBase = preg_replace('/[^A-Za-z0-9_\-]/', '_', $base);
                    $uniqueSuffix = time() . '_' . bin2hex(random_bytes(4));
                    $fileName = $safeBase . '_' . $uniqueSuffix . '.' . $ext;

                    move_uploaded_file($tmpName, $uploadDir . $fileName);
                }
            }

            header("Location: 05-planety-detail.php?id=" . $id);
            exit();
        }
        ?>
</head>
<body>
    <form  method="post">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($planet['id']); ?>">
        <label for="name">Název:</label>
        <input type="text" id="name" name="nazev" value="<?php echo htmlspecialchars($planet['nazev']); ?>"><br><br>
        <label for="radius">Poloměr:</label>
        <input type="text" id="radius" name="polomer" value="<?php echo htmlspecialchars($planet['polomer']); ?>"><br><br>
        <label for="distance">Vzdálenost od Slunce:</label>
        <input type="text" id="distance" name="vzdalenost" value="<?php echo htmlspecialchars($planet['vzdalenost']); ?>"><br><br>
        <label for="moons">URL obrázku v headeru:</label>
        <input type="text" id="moons" name="url_obrazek" value="<?php echo htmlspecialchars($planet['url_obrazek']); ?>"><br><br>
        <label for="popiskratky">Popis (krátký):</label>
        <!-- Textarea for short description -->
        <textarea id="popiskratky" name="popiskratky"><?php echo htmlspecialchars($planet['popis_kratky']); ?></textarea><br><br>
        <label for="wikipedia_url">URL na Wikipedii:</label>
        <input type="text" id="wikipedia_url" name="wikipedia" value="<?php echo htmlspecialchars($planet['wikipedia']); ?>"><br><br>
        <label for="clanek">Článek:</label>
        <textarea id="clanek" name="clanek"><?php echo htmlspecialchars($planet['clanek']); ?></textarea><br><br>
        <div class="image-section" style="display: flex; flex-wrap: wrap; gap: 10px;">
        <label for="obrazky">Obrázky:</label>
        <?php foreach (getAllImagesInFolder("planeta/". $planet['id']) as $imagePath): ?>

            <div>
                <?php echo $imagePath; ?><br>
                <img src="<?php echo htmlspecialchars($imagePath); ?>" alt="Planet Image" style="max-width: 200px;"><br>
                <input type="checkbox" name="delete_images[]" value="<?php echo htmlspecialchars(basename($imagePath)); ?>"> Smazat tento obrázek
            </div>
        <?php endforeach; ?>
        </div>
        <label for="obrazky">Nahrát nové obrázky:</label>
        <input type="file" id="obrazky" name="obrazky[]" multiple><br><br>

        <input type="submit" value="Update Planetu">
</body>

</html>