<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <title>Ankety</title>
</head>
<body class="container mt-5">

    <h2 class="mb-4">Anketa</h2>

    <?php
    $soubor = "anketa.txt"; 

    $ano1 = $ne1 = $ano2 = $ne2 = 0;
    $suma_hodnoceni = 0;
    $pocet_hlasu = 0;

    if (file_exists($soubor)) {
        $hlasovani = file($soubor, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        if (!empty($hlasovani[0])) list($ano1, $ne1) = explode(",", $hlasovani[0]);
        if (!empty($hlasovani[1])) list($ano2, $ne2) = explode(",", $hlasovani[1]);
        if (!empty($hlasovani[2])) list($suma_hodnoceni, $pocet_hlasu) = explode(",", $hlasovani[2]);
    }

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        if (isset($_POST["q1"])) {
            if ($_POST["q1"] == "ano") {
                $ano1++;
            } else {
                $ne1++;
            }
        }

        if (isset($_POST["q2"])) {
            if ($_POST["q2"] == "ano") {
                $ano2++;
            } else {
                $ne2++;
            }
        }

        if (isset($_POST["q3"])) {
            $suma_hodnoceni += intval($_POST["q3"]);
            $pocet_hlasu++;
        }

        file_put_contents($soubor, "$ano1,$ne1\n$ano2,$ne2\n$suma_hodnoceni,$pocet_hlasu\n");
        header("Location: ".$_SERVER['PHP_SELF']);
        exit;
    }


    $prumer = ($pocet_hlasu > 0) ? round($suma_hodnoceni / $pocet_hlasu, 1) : 0;
    ?>


    <form method="post">
        <h4>1) Dívali jste se na letošní Oscary?</h4>
        <input type="radio" name="q1" value="ano" required> Ano
        <input type="radio" name="q1" value="ne" required> Ne
        <br><br>

        <h4>2) Těšíte se na maturitu?</h4>
        <input type="radio" name="q2" value="ano" required> Ano
        <input type="radio" name="q2" value="ne" required> Ne
        <br><br>

        <h4>3) Ohodnoťte divadelní představení</h4>
        <?php for ($i = 5; $i >= 1; $i--): ?>
            <input type="radio" name="q3" value="<?= $i ?>" required> <?= $i ?>
        <?php endfor; ?>
        <br><br>

        <button type="submit" class="btn btn-primary">Odeslat</button>
    </form>

    <hr>

    <h2 class="mb-4">Výsledky</h2>

    <?php
    function zobrazProgressBar($ano, $ne) {
        $celkem = $ano + $ne;
        if ($celkem > 0) {
            $ano_procenta = round(($ano / $celkem) * 100);
            $ne_procenta = 100 - $ano_procenta;
            echo '<div class="progress mb-3">';
            echo '<div class="progress-bar bg-success" style="width: '.$ano_procenta.'%;">'.$ano_procenta.'%</div>';
            echo '<div class="progress-bar bg-danger" style="width: '.$ne_procenta.'%;">'.$ne_procenta.'%</div>';
            echo '</div>';
            echo "<p>Ano: $ano hlasů, Ne: $ne hlasů (Celkem: $celkem hlasů)</p>";
        } else {
            echo "<p>Zatím žádné hlasy.</p>";
        }
    }

    echo "<h4>Oscary</h4>";
    zobrazProgressBar($ano1, $ne1);

    echo "<h4>Maturita</h4>";
    zobrazProgressBar($ano2, $ne2);

    echo "<h4>Divadlo</h4>";
    echo "<p>Průměrné hodnocení: <strong>$prumer</strong> (5 = nejlepší)</p>";
    ?>

</body>
</html>
