<?php 
    $server = "websql.in.spsostrov.cz";
    $data = parse_ini_file("../spso.mysql.ini");
    $username = $data["username"];
    $password = $data["password"];
    $database = $data["database"];

    $pdo = new PDO(
        "mysql:host=$server;dbname=$database;charset=utf8mb4", 
        $username, 
        $password,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION] 
    );

    if(isset($_GET["j"]) && isset($_GET["p"])) {
        $jmeno = $_GET["j"];
        $prijmeni = $_GET["p"];
        $narozeni = 2000;
        $plat = 10000;

        $sql = "INSERT INTO zamestnanci (jmeno, prijmeni, narozeni, plat)
                VALUES (:jmeno, :prijmeni, :narozeni, :plat)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':jmeno', $jmeno); 
        $stmt->bindParam(':prijmeni', $prijmeni); 
        $stmt->bindParam(':narozeni', $narozeni); 
        $stmt->bindParam(':plat', $plat); 

        $stmt->execute();
    }

    $res = $pdo->query("SELECT * FROM zamestnanci")->fetchAll(PDO::FETCH_ASSOC);
    vypis($res);
    
    // Uzavření spojení s databází
    $pdo = null;

    function vypis($data) {
        echo "<table border='1'>";
        foreach ($data as $row) {
            echo "<tr>";
            foreach($row as $item) {
                echo "<td>$item</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    }
?>
