<?php
session_start();
require 'database.php';

// Kontrola přihlášení
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: access.php");
    exit;
}

// Získání dat z POST
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$brand_id = $_POST['brand_id'];
$model = $_POST['model'];
$price = $_POST['price'];
$color = $_POST['color'];
$category_id = $_POST['category_id'];
$image_main = $_POST['image_main'];
$image_gallery = $_POST['image_gallery'];
$description = $_POST['description'];

// Vložení nebo aktualizace podle přítomnosti ID
if ($id > 0) {
    // 🔄 UPDATE
    $sql = "UPDATE bikes SET 
                brand_id = :brand_id,
                model = :model,
                price = :price,
                color = :color,
                category_id = :category_id,
                image_main = :image_main,
                image_gallery = :image_gallery,
                description = :description
            WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':brand_id' => $brand_id,
        ':model' => $model,
        ':price' => $price,
        ':color' => $color,
        ':category_id' => $category_id,
        ':image_main' => $image_main,
        ':image_gallery' => $image_gallery,
        ':description' => $description,
        ':id' => $id
    ]);
} else {
    // ➕ INSERT
    $sql = "INSERT INTO bikes 
            (brand_id, model, price, color, category_id, image_main, image_gallery, description) 
            VALUES 
            (:brand_id, :model, :price, :color, :category_id, :image_main, :image_gallery, :description)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':brand_id' => $brand_id,
        ':model' => $model,
        ':price' => $price,
        ':color' => $color,
        ':category_id' => $category_id,
        ':image_main' => $image_main,
        ':image_gallery' => $image_gallery,
        ':description' => $description
    ]);
}

// Přesměrování zpět do dashboardu
header("Location: admin_dashboard.php");
exit;
